/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.onionwrapper;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.concurrent.Immutable;
import javax.inject.Inject;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.nullsafety.NullSafety;
import org.briarproject.onionwrapper.CircumventionProvider;

@NotNullByDefault
@Immutable
class CircumventionProviderImpl
implements CircumventionProvider {
    private static final String BRIDGE_FILE_NAME = "bridges";
    private static final String SNOWFLAKE_PARAMS_FILE_NAME = "snowflake-params";
    private static final String DEFAULT_COUNTRY_CODE = "ZZ";
    private static final Set<String> BLOCKED_IN_COUNTRIES = new HashSet<String>(Arrays.asList(BLOCKED));
    private static final Set<String> BRIDGE_COUNTRIES = new HashSet<String>(Arrays.asList(BRIDGES));
    private static final Set<String> DEFAULT_OBFS4_BRIDGE_COUNTRIES = new HashSet<String>(Arrays.asList(DEFAULT_BRIDGES));
    private static final Set<String> NON_DEFAULT_BRIDGE_COUNTRIES = new HashSet<String>(Arrays.asList(NON_DEFAULT_BRIDGES));
    private static final Set<String> DPI_COUNTRIES = new HashSet<String>(Arrays.asList(DPI_BRIDGES));

    @Inject
    CircumventionProviderImpl() {
    }

    @Override
    public boolean isTorProbablyBlocked(String countryCode) {
        return BLOCKED_IN_COUNTRIES.contains(countryCode);
    }

    @Override
    public boolean doBridgesWork(String countryCode) {
        return BRIDGE_COUNTRIES.contains(countryCode);
    }

    @Override
    public List<CircumventionProvider.BridgeType> getSuitableBridgeTypes(String countryCode) {
        if (DEFAULT_OBFS4_BRIDGE_COUNTRIES.contains(countryCode)) {
            return Arrays.asList(CircumventionProvider.BridgeType.DEFAULT_OBFS4, CircumventionProvider.BridgeType.VANILLA);
        }
        if (NON_DEFAULT_BRIDGE_COUNTRIES.contains(countryCode)) {
            return Arrays.asList(CircumventionProvider.BridgeType.NON_DEFAULT_OBFS4, CircumventionProvider.BridgeType.VANILLA);
        }
        if (DPI_COUNTRIES.contains(countryCode)) {
            return Arrays.asList(CircumventionProvider.BridgeType.NON_DEFAULT_OBFS4, CircumventionProvider.BridgeType.MEEK, CircumventionProvider.BridgeType.SNOWFLAKE);
        }
        return Arrays.asList(CircumventionProvider.BridgeType.DEFAULT_OBFS4, CircumventionProvider.BridgeType.VANILLA);
    }

    @Override
    public List<String> getBridges(CircumventionProvider.BridgeType type, String countryCode, boolean letsEncrypt) {
        InputStream is = (InputStream)NullSafety.requireNonNull((Object)this.getClass().getClassLoader().getResourceAsStream(BRIDGE_FILE_NAME));
        Scanner scanner = new Scanner(is);
        ArrayList<String> bridges = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (type == CircumventionProvider.BridgeType.DEFAULT_OBFS4 && line.startsWith("d ") || type == CircumventionProvider.BridgeType.NON_DEFAULT_OBFS4 && line.startsWith("n ") || type == CircumventionProvider.BridgeType.VANILLA && line.startsWith("v ") || type == CircumventionProvider.BridgeType.MEEK && line.startsWith("m ")) {
                bridges.add(line.substring(2));
                continue;
            }
            if (type != CircumventionProvider.BridgeType.SNOWFLAKE || !line.startsWith("s ")) continue;
            String params = this.getSnowflakeParams(countryCode, letsEncrypt);
            bridges.add(line.substring(2) + " " + params);
        }
        scanner.close();
        return bridges;
    }

    String getSnowflakeParams(String countryCode, boolean letsEncrypt) {
        String value;
        Map<String, String> params = this.loadSnowflakeParams();
        if (countryCode.isEmpty()) {
            countryCode = DEFAULT_COUNTRY_CODE;
        }
        if ((value = params.get(this.makeKey(countryCode, letsEncrypt))) != null) {
            return value;
        }
        value = params.get(this.makeKey(DEFAULT_COUNTRY_CODE, letsEncrypt));
        return (String)NullSafety.requireNonNull((Object)value);
    }

    private Map<String, String> loadSnowflakeParams() {
        InputStream is = (InputStream)NullSafety.requireNonNull((Object)this.getClass().getClassLoader().getResourceAsStream(SNOWFLAKE_PARAMS_FILE_NAME));
        Scanner scanner = new Scanner(is);
        TreeMap<String, String> params = new TreeMap<String, String>();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.length() < 5) continue;
            String key = line.substring(0, 4);
            String value = line.substring(5);
            params.put(key, value);
        }
        scanner.close();
        return params;
    }

    private String makeKey(String countryCode, boolean letsEncrypt) {
        return countryCode + " " + (letsEncrypt ? "1" : "0");
    }
}

