/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.onionwrapper;

import com.sun.jna.platform.win32.Kernel32;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.onionwrapper.JavaTorWrapper;

@NotNullByDefault
public class WindowsTorWrapper
extends JavaTorWrapper {
    public WindowsTorWrapper(Executor ioExecutor, Executor eventExecutor, String architecture, File torDirectory, int torSocksPort, int torControlPort) {
        super(ioExecutor, eventExecutor, architecture, torDirectory, torSocksPort, torControlPort);
    }

    protected int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    protected void waitForTorToStart(Process torProcess) throws InterruptedException, IOException {
        ArrayBlockingQueue success = new ArrayBlockingQueue(1);
        this.ioExecutor.execute(() -> {
            boolean started = false;
            Scanner stdout = new Scanner(torProcess.getInputStream());
            if (stdout.hasNextLine()) {
                LOG.info(stdout.nextLine());
            }
            while (stdout.hasNextLine()) {
                String line = stdout.nextLine();
                if (started || !line.contains("Opened Control listener")) continue;
                success.add(true);
                started = true;
            }
            stdout.close();
            if (!started) {
                success.add(false);
            }
            try {
                int exit = torProcess.waitFor();
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Tor exited with value " + exit);
                }
            }
            catch (InterruptedException e1) {
                LOG.warning("Interrupted while waiting for Tor to exit");
                Thread.currentThread().interrupt();
            }
        });
        if (!((Boolean)success.take()).booleanValue()) {
            throw new IOException();
        }
    }

    protected String getExecutableExtension() {
        return ".exe";
    }
}

